/*****************************************************************************
 *   cordic.h: Header file for cordic routines
 *
 *   History
 *   2009.12.17  ver 1.00    Preliminary version, first Release
 *
 **************************************************************************** 
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/
 
/*****************************************************************************
 * This code has been copied from its original author 
 *
 * Copyright (C) 1981-1999 Ken Turkowski.
 *
 * All rights reserved.
 *
 * Warranty Information
 *  Even though I have reviewed this software, I make no warranty
 *  or representation, either express or implied, with respect to this
 *  software, its quality, accuracy, merchantability, or fitness for a
 *  particular purpose.  As a result, this software is provided "as is,"
 *  and you, its user, are assuming the entire risk as to its quality
 *  and accuracy.
 *
 * This code may be used and freely distributed as long as it includes
 * this copyright notice and the above warranty information.
 *
 *****************************************************************************/

#ifndef __CORDIC_H
#define __CORDIC_H

#define FASTER
#define RADIANS 1
# define COSCALE 0x11616E8E /* 291597966 = 0.2715717684432241 * 2^30, valid for j>13 */
#define PI			3.14159		// PI

static long arctantab[] = {
#ifdef DEGREES      /* 16 fractional bits */
# define QUARTER (90L << 16)
# define MAXITER 22 /* the resolution of the arctan table */
    4157273, 2949120, 1740967, 919879, 466945, 234379, 117304, 58666,
    29335, 14668, 7334, 3667, 1833, 917, 458, 229,
    115, 57, 29, 14, 7, 4, 2, 1
#else /* !DEGREES */
# ifdef RADIANS /* 16 fractional bits */
#  define QUARTER ((long)(3.141592654 / 2.0 * (1L << 16)))
#  define MAXITER 16    /* the resolution of the arctan table */
    72558, 51472, 30386, 16055, 8150, 4091, 2047, 1024,
    512, 256, 128, 64, 32, 16, 8, 4,
    2, 1
#  else /* !RADIANS && !DEGREES */
#  define BRADS 1
#  define QUARTER (1L << 30)
#  define MAXITER 29    /* the resolution of the arctan table */
    756808418, 536870912, 316933406, 167458907, 85004756, 42667331,
    21354465, 10679838, 5340245, 2670163, 1335087, 667544, 333772, 166886,
    83443, 41722, 20861, 10430, 5215, 2608, 1304, 652, 326, 163, 81, 41,
    20, 10, 5, 3, 1
# endif /* !RADIANS && !DEGREES */
#endif /* !DEGREES */

};


/* To rotate a vector through an angle of theta, we calculate:
 *
 *  x' = x cos(theta) - y sin(theta)
 *  y' = x sin(theta) + y cos(theta)
 *
 * The rotate() routine performs multiple rotations of the form:
 *
 *  x[i+1] = cos(theta[i]) { x[i] - y[i] tan(theta[i]) }
 *  y[i+1] = cos(theta[i]) { y[i] + x[i] tan(theta[i]) }
 *
 * with the constraint that tan(theta[i]) = pow(2, -i), which can be
 * implemented by shifting. We always shift by either a positive or
 * negative angle, so the convergence has the ringing property. Since the
 * cosine is always positive for positive and negative angles between -90
 * and 90 degrees, a predictable magnitude scaling occurs at each step,
 * and can be compensated for instead at the end of the iterations by a
 * composite scaling of the product of all the cos(theta[i])'s.
 */


typedef long TFract;    /* f * 2^30 */
TFract FFracMul(TFract a, TFract b);

extern void FxUnitVec(long *cos, long *sin, long theta);
extern void FxRotate(long *argx, long *argy, long theta);
extern long FxAtan2(long x, long y);
extern void FxPolarize(long *argx, long *argy);
extern long FFracMul(long a, long b);
extern void PseudoRotate(long *px, long *py, register long theta);
extern void PseudoPolarize(long *argx, long *argy);
#ifndef FASTER
extern int FxPreNorm(long *argx, long *argy);
#endif


#endif /* __CORDIC_H */

